#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "RandomValues.h"
#include <QString>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
    , ui(new Ui::MainWindow)
{
    ui->setupUi(this);
}

MainWindow::~MainWindow()
{
    if (pRandomValues)
    {
        delete pRandomValues;
        delete pEnded;
    }
    delete ui;
}

void MainWindow::on_pushButtonExit_clicked()
{
    if (pEnded)
    {
        *pEnded = true;
    }
    else
    {
        exit(0);
    }
 }


void MainWindow::on_pushButtonRun_clicked()
{
    pEnded = new QAtomicInt;
    *pEnded = false;
    pRandomValues = new RandomValues(pEnded);
    connect(pRandomValues, &RandomValues::finished, this, &MainWindow::waitThreadEnd);
    connect(pRandomValues, &RandomValues::finished, pRandomValues, &QObject::deleteLater);
    connect(pRandomValues, &RandomValues::result, this, &MainWindow::showResult);
    pRandomValues->start();
    ui->pushButtonRun->setEnabled(false);
}

void MainWindow::waitThreadEnd()
{
    pRandomValues->wait();
    exit(0);
}

void MainWindow::showResult(int x)
{
    QString qs = QString::number(x);
    ui->lineEditValue->setText(qs);
}

